﻿using Tinycc.Resources;

namespace Tinycc;

public interface IClient
{
    /// <summary>
    /// Get account information like subscription status and usage of account resources
    /// </summary>
    Task<AccountResponse> AccountInfoAsync();

    /// <summary>
    /// Read list of shortening domains in account
    /// </summary>
    Task<DomainsResponse> DomainsAsync();

    /// <summary>
    /// Read list of all existing tags
    /// </summary>
    Task<TagsResponse> TagsAsync();

    /// <summary>
    /// Create new tag (if it's not exist)
    /// </summary>
    Task<CreateTagResponse> CreateTagAsync(string label);

    /// <summary>
    /// Edit (rename) existing tag
    /// </summary>
    Task<EditTagResponse> EditTagAsync(string label, string newLabel);

    /// <summary>
    /// Delete tag with given label
    /// </summary>
    Task<DeleteTagResponse> DeleteTagAsync(string label);

    /// <summary>
    /// Shorten single URL
    /// </summary>
    Task<ShortenResponse> ShortenAsync(string url, string disableLongUrlDuplicates = null);

    /// <summary>
    /// Shorten single URL
    /// </summary>
    Task<ShortenResponse> ShortenAsync(ShortenParams url, string disableLongUrlDuplicates = null);

    /// <summary>
    /// Shorten many URLs
    /// </summary>
    Task<MassShortenResponse> MassShortenAsync(IEnumerable<ShortenParams> urls, string disableLongUrlDuplicates = null);

    /// <summary>
    /// Read paginated index of shortened URLs
    /// </summary>
    Task<ReadResponse> ReadPageAsync(
        string search = null, IEnumerable<string> hashes = null, IEnumerable<string> tags = null,
        int? offset = null, int? limit = null, ReadOrderBy? orderBy = null);

    /// <summary>
    /// Read properties of selected URL(s)
    /// </summary>
    Task<ReadResponse> ReadAsync(
        string search = null, IEnumerable<string> hashes = null, IEnumerable<string> tags = null);

    /// <summary>
    /// Change properties of selected URL. Will return updated URL data.
    /// </summary>
    Task<EditResponse> EditAsync(EditParams url);

    /// <summary>
    /// Change properties of selected URLs. Will return updated URLs data.
    /// </summary>
    Task<MassEditResponse> EditAsync(IEnumerable<EditParams> urls);

    /// <summary>
    /// Change properties of selected URLs. Will return updated URLs data.
    /// </summary>
    Task<MassEditResponse> EditAsync(EditParams data, IEnumerable<string> hashes = null, IEnumerable<string> tags = null);

    /// <summary>
    /// Delete selected URL
    /// </summary>
    Task<DeleteResponse> DeleteAsync(string hash);

    /// <summary>
    /// Delete selected URLs
    /// </summary>
    Task<DeleteResponse> DeleteAsync(IEnumerable<string> hashes = null, IEnumerable<string> tags = null);

    /// <summary>
    /// Read click statistics of short link
    /// </summary>
    Task<StatsResponse> StatsAsync(string hash);

    /// <summary>
    /// Reset clicks stats for selected URL
    /// </summary>
    Task<ResetStatsResponse> ResetStatsAsync(string hash);

    /// <summary>
    /// Reset clicks stats for selected URLs
    /// </summary>
    Task<ResetStatsResponse> ResetStatsAsync(IEnumerable<string> hashes = null, IEnumerable<string> tags = null);

    /// <summary>
    /// Read Smart Links routing rule types
    /// </summary>
    Task<MetaCriterionResponse> MetaCriterionAsync();

    /// <summary>
    /// Read Supported Browsers
    /// </summary>
    Task<Dictionary<string, MetaBrowserResponse>> MetaBrowserAsync();

    /// <summary>
    /// Read Supported Countries
    /// </summary>
    Task<Dictionary<string, MetaCountryResponse>> MetaCountryAsync();

    /// <summary>
    /// Read Supported Languages
    /// </summary>
    Task<Dictionary<string, MetaLanguageResponse>> MetaLanguageAsync();

    /// <summary>
    /// Read Supported Platforms
    /// </summary>
    Task<Dictionary<string, MetaPlatformResponse>> MetaPlatformAsync();

    /// <summary>
    /// Read Smart Link routing rules
    /// </summary>
    Task<SmartLinkResponse> SmartLinkAsync(string hash);

    /// <summary>
    /// Set new Smart Link routing rules
    /// </summary>
    Task<EditSmartLinkResponse> EditSmartLinkAsync(string hash, IEnumerable<Rule> rules);
}
